varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform float		wFar;
varying vec2		VPOS;
uniform mat4		reprojTM;
uniform mat4		projTM;

vec2 getScreenPos(vec4 pos)
{
	vec4 ppos;
	vec2 spos;
		
	// compute texture space pos
	ppos=projTM*pos;
	ppos=ppos/ppos.w;
	spos=vec2(1.0)-ppos.xy;
	return spos;
}

vec4 getEyePos(vec2 coords)
{
	vec4 pos;
	pos.z = -wFar;//texture2D(depthTex, coords.xy).r;
	pos.xy=VPOS*-pos.z;
	pos.w=1.0;
	return pos;
}

vec2 reproject(vec2 coords)
{
	vec4 eye=getEyePos(coords.st);
	vec4 prevEye=reprojTM*eye;
	return getScreenPos(prevEye);
}

void main()
{
	vec4 prevST=vec4(0.0,0.0,0.0,1.0);
	vec2 uv=reproject(texcoord);
	if(uv.x>=0 && uv.y>=0 && uv.x<1.0 && uv.y<1.0)
	{
		gl_FragColor=texture2D(tex,uv.st);
	}
	else
		discard;
}
